#!/usr/bin/env bash
set -e

## 
# In order to emulate the base notebook functions properly when using
# batchspawner-singleuser & jupyterhub-singleuser we need to use our own startscript
# since both scripts are python only and don't e.g. execute the hooks
# that would otherwise be executed by the docker-stacks start script
#
# See: https://github.com/jupyter/docker-stacks/blob/master/base-notebook/start.sh
##

# The _log function is used for everything this script wants to log. It will
# always log errors and warnings, but can be silenced for other messages
# by setting JUPYTER_DOCKER_STACKS_QUIET environment variable.
_log () {
    if [[ "$*" == "ERROR:"* ]] || [[ "$*" == "WARNING:"* ]] || [[ "${JUPYTER_DOCKER_STACKS_QUIET}" == "" ]]; then
        echo "$@"
    fi
}

run-hooks () {
    if [[ ! -d "${1}" ]] ; then
        return
    fi
    _log "${0}: running hooks in ${1} as uid / gid: $(id -u) / $(id -g)"
    for f in "${1}/"*; do
        case "${f}" in
            *.sh)
                _log "${0}: running script ${f}"
                # shellcheck disable=SC1090
                source "${f}"
                ;;
            *)
                if [[ -x "${f}" ]] ; then
                    _log "${0}: running executable ${f}"
                    "${f}"
                else
                    _log "${0}: ignoring non-executable ${f}"
                fi
                ;;
        esac
    done
    _log "${0}: done running hooks in ${1}"
}

_log "Entered vsc-singleuser.sh with args:" "$@"

run-hooks /usr/local/bin/before-notebook.d

batchspawner-singleuser jupyterhub-singleuser $@
