#!/usr/bin/env bash

# Additional hook for /usr/local/bin/before-notebook.d
# to make r user package installs work in the singularity images
# Note: the name contains a 'z' so the script is executed last

VSC_R_PACKAGES=$HOME/.rpackages
VSC_R_LIB_USER_PATH=$VSC_R_PACKAGES/user
VSC_TRAINING_R_LIB_USER_PATH=$VSC_R_PACKAGES/training

# update R_LIBS_USER with both paths at all time
export R_LIBS_USER=$VSC_R_LIB_USER_PATH:$VSC_TRAINING_R_LIB_USER_PATH:$R_LIBS_USER

# make sure the directory is existing (or else R won't recognize it)
mkdir -p $VSC_R_LIB_USER_PATH

# find out whats the correct training directory
TRAINING_DIR='/home/fs70824/training'
if [ ! -e "$TRAINING_DIR" ]; then
    TRAINING_DIR='/home/lv70824/training'
    if [ ! -e "$TRAINING_DIR" ]; then
        echo "training dir not found - skipping."
        return 0
    fi
fi

# create a (possibly broken) link
# note: the link will only be valid when used with the training profile
#   where the additional training folder is mounted into the image
pushd $VSC_R_PACKAGES >/dev/null
if [ ! -L training ]; then
    ln -s $TRAINING_DIR training
fi
popd >/dev/null

return 0
