# Image builds

## '.def' file

In order to create an image file suitable for our VSC JupyterHub instance you first have to create a '.def' file that tells singularity how to build the actual image. This can be made from scratch or by e.g. using a previously built docker image.

If you want to use a docker image in moste cases the following definition is enough. You just have to replace `<docker-image-tag>` with the right tag you want to base your image on. In the `post` step we want to add the batchspawner package in order to be able for the image to work together with JupyterHub. If you have a different python installation in your image you need to adjust the path to the `pip` executable as well.

```singularity
    BootStrap: docker
    From: <docker-image-tag>

    %post
    /opt/conda/bin/pip install batchspawner==1.1.0
```

## '.meta' file

Our Jupyterhub uses self-defined '.meta' files to automatically add the existing images to a dropdown list in the UI.

For this mechanism to work you just have to place a `.meta` file with the same name as the `.def` file in the same directory.

```json
    {
        "title": "Base Notebook ({group})",
        "description": "Base image of the jupyter docker core stacks containing python3",
        "link": "https://github.com/jupyter/docker-stacks",
        "version": "hub-1.4.2",
        "author": "VSC",
        "contact": "service@vsc.ac.at",
        "required-caps": [],
        "exclude-caps": ["gpu"],
        "required-groups": [],
        "order": 0
    }
```

The `.meta` files contents must conform to JSON specifications. It can contain fields as listed above in the examples.

The `title` field may use the `{group}` tag which automatically gets filled with the folder name the image is stored in (empty if its in the root directory of the image share).

Most of the other fields are pretty self explanatory: the `description` field can contain a small description of whats in the image. This description will be displayed in the UI upon selecting the image frmo the drop down. Similar to this field the `link` will also be displayed there.

`version` should correspond to the contained version of the image.

`required-caps` determines in which cluster configurations the image can be used and `exclude-caps` tells the system that the image cannot be used if one of the caps is present. Possible required caps are:

- `vcs3`
- `vsc4`
- `gpu`

`required-groups` determines which groups the user needs to have for the image to be enabled. If there are no groups specified it is visible for all users.

`order` is a simple integer number to override the lexicographical order within a folder

## Building

Once checked in and added to `.gitlab-ci.yml` (just copy an example job and adjust), the image can be built by going to the gitlab page of the [repository](https://gitlab.tuwien.ac.at/vsc/vsc-jupyterhub-notebooks) and running the added image job.

After a sucessful build the image will be automatically copied to

- VSC3 Shares: USIF/jupyter-notebook/\<image-tag\>
- VSC4 Shares: usif/jupyter-notebook/\<image-tag\>

and should be available from the dropdown of the UI.

Note: In case the built image doesn't show up immediately log out and login again to trigger the loading of existing meta files. You can also check the `admin` section in JupyterHub where all images that have been read in are listed.
