from django.contrib.auth import login, update_session_auth_hash
from django.shortcuts import redirect, render
from django.urls import reverse
from users.forms import CustomUserCreationForm
from django.contrib import messages
from django.contrib.auth.forms import PasswordChangeForm, PasswordResetForm
from django.contrib.auth.views import PasswordChangeView, PasswordResetView
from django.contrib.auth.views import PasswordChangeDoneView, PasswordResetDoneView, PasswordResetConfirmView, PasswordResetCompleteView
from django.urls import reverse_lazy

def dashboard(request):
    return render(request, "dashboard.html")

def register(request):
    if request.method == "GET":
        form = CustomUserCreationForm()
    elif request.method == "POST":
        form = CustomUserCreationForm(request.POST)
        if form.is_valid():
            user = form.save()
            login(request, user)
            return redirect(reverse("dashboard"))
    return render(request, "registration/register.html", {"form": form})

#
# class ChangePasswordDoneView(PasswordChangeDoneView):
#     template_name = 'registration/password_change_done.html'
#
# class ResetPasswordDoneView(PasswordResetDoneView):
#     template_name = 'registration/password_reset_done.html'
#
# class ResetPasswordCompleteView(PasswordResetCompleteView):
#     template_name = 'registration/password_reset_complete.html'
#
# class ChangePasswordView(PasswordChangeView):
#     form_class = PasswordChangeForm
#     success_url = reverse_lazy('password-change-done')
#     template_name = 'registration/password_change_form.html'
#
# class ResetPasswordView(PasswordResetView):
#     form_class = PasswordResetForm
#     success_url = reverse_lazy('password-reset-done')
#     template_name = 'registration/password_reset_form.html'
#
# class ResetPasswordConfirmView(PasswordResetConfirmView):
#     form_class = PasswordResetConfirmView
#     success_url = reverse_lazy('password-reset-complete')
#     template_name = 'registration/password_reset_confirm.html'



######
# def change_password_form(request):
#     if request.method == 'POST':
#         form = PasswordChangeForm(request.user, request.POST)
#         if form.is_valid():
#             user = form.save()
#             update_session_auth_hash(request, user)  # Important!
#             messages.success(request, 'Your password was successfully updated!')
#             return redirect(reverse("password_change_done"))
#         else:
#             messages.error(request, 'Please correct the error below.')
#     else:
#         form = PasswordChangeForm(request.user)
#     return render(request, 'registration/password_change_form.html', {'form': form})



