from django.shortcuts import render
from load_data.models import StromrechnungenDataAll
from django_pandas.io import read_frame
import datetime
import pandas as pd
# Create your views here.

def test_plot(request):
    month_names = {1: "Januar", 2: "Februar", 3: "März", 4: "April", 5: "Mai", 6: "Juni", 7: "Juli", 8: "August",
                   9: "September", 10: "Oktober", 11: "November", 12: "Dezember"}

    dataquery = StromrechnungenDataAll.objects.all()

    dataframe = read_frame(dataquery)

    # Sort data by date
    dataframe = dataframe.sort_values('Date')

    # Group by Year and Monat, and calculate the sum of Verbrauch_kWh
    df_grouped = dataframe.groupby(['Year', 'Monat']).agg({'Verbrauch_kWh': 'sum'}).reset_index()

    # get average from last five years
    last_year = datetime.datetime.now().year - 1
    df_average = df_grouped[(df_grouped['Year'] >= last_year - 5) & (df_grouped['Year'] < last_year)]
    df_average = df_average.groupby(['Monat']).agg({'Verbrauch_kWh': 'mean'}).reset_index()
    df_average['Year'] = "Durchschnitt"

    df_grouped = pd.concat([df_grouped, df_average], ignore_index=True)

    # Define bubble size and color based on sum
    # df_grouped['bubble_size'] = df_grouped['Verbrauch_kWh'] * 0.01  # Adjust the scaling factor as needed
    # df_grouped['bubble_color'] = ['red' if x > df_grouped['Verbrauch_kWh'].mean() else 'green' for x in
    #                              df_grouped['Verbrauch_kWh']]

    # Replace month numbers with names
    df_grouped['Monat'] = df_grouped['Monat'].map(month_names)

    # Convert 'Year' column to string
    df_grouped['Year'] = df_grouped['Year'].astype(str)

    # Convert 'Verbrauch_kWh' column to numeric
    df_grouped['Verbrauch_kWh'] = pd.to_numeric(df_grouped['Verbrauch_kWh'])

    # Pass the DataFrame data to the template
    context = {
        'df_grouped': df_grouped.to_json(orient='records')  # Convert DataFrame to JSON for passing to template
    }

    return render(request, 'test.html', context)
