from load_data.models import StromrechnungenDataAll
from load_data.models import StandortTransition
from overview.plots import monatliche_verbrauch_df
from django_pandas.io import read_frame
import datetime
import pandas as pd
import plotly.graph_objects as go
import math


print(monatliche_verbrauch_df())
import plotly.graph_objs as go

# Function to generate mock data, replace with your actual data
def monatliche_verbrauch_df():
    pass  # Replace this with your actual implementation

# Define quarter names
quarter_names = {1: "Q1", 2: "Q2", 3: "Q3", 4: "Q4"}

# Generate sample data
# df_monthly = monatliche_verbrauch_df()

import plotly.graph_objs as go

# Function to generate mock data, replace with your actual data
def monatliche_verbrauch_df():
    pass  # Replace this with your actual implementation

# Define quarter names
quarter_names = {1: "Q1", 2: "Q2", 3: "Q3", 4: "Q4"}

# Generate sample data
# df_monthly = monatliche_verbrauch_df()

# For the sake of demonstration, let's create some mock data
import pandas as pd
data = {
    'Year': [2022, 2022, 2022, 2022, 2023, 2023, 2023, 2023],
    'Month': [1, 2, 3, 4, 1, 2, 3, 4],
    'Verbrauch_kWh': [100000, 150000, 200000, 180000, 120000, 180000, 190000, 210000]
}
df_monthly = pd.DataFrame(data)
df_monthly['Quarter'] = df_monthly['Month'].apply(lambda x: quarter_names[(x - 1) // 3 + 1])

# Group by Year and Quarter, and sum the consumption for each quarter
df_quarterly = df_monthly.groupby(['Year', 'Quarter'])['Verbrauch_kWh'].sum().reset_index()

# Calculate total consumption for each year
df_yearly_total = df_quarterly.groupby('Year')['Verbrauch_kWh'].sum().reset_index()

# Convert Verbrauch_kWh to GWh
df_quarterly['Verbrauch_kWh'] /= 1000000
df_yearly_total['Verbrauch_kWh'] /= 1000000

# Getting the years
years = df_quarterly['Year'].unique()

# Getting the quarters
quarters = df_quarterly['Quarter'].unique()

# Creating traces for each quarter
traces = []
for quarter in quarters:
    # Filter the DataFrame for the current quarter
    quarter_data = df_quarterly[df_quarterly['Quarter'] == quarter]

    trace = go.Bar(
        x=quarter_data['Year'],
        y=quarter_data['Verbrauch_kWh'],
        name=quarter
    )
    traces.append(trace)

# Adding total consumption annotations
annotations = []
for year in years:
    total_consumption = df_yearly_total[df_yearly_total['Year'] == year]['Verbrauch_kWh'].values[0]
    annotation = dict(
        x=year,
        y=total_consumption + 0.1,  # Adjust position for annotation
        xref="x",
        yref="y",
        text=f"Total: {total_consumption:.2f} GWh",
        showarrow=False,
        font=dict(
            size=10,
            color="black"
        )
    )
    annotations.append(annotation)

# Creating the layout
layout = go.Layout(
    title='Vierteljährlicher Stromverbrauch',
    xaxis=dict(title='Year', dtick=1),
    yaxis=dict(title='Verbrauch [GWh]'),
    barmode='stack',
    margin=dict(l=0, r=0, b=50, t=30),  # Adjust bottom margin for annotations
    plot_bgcolor='rgba(0,0,0,0)',
    legend=dict(
        orientation="v",
        yanchor="top",
        y=0.99,
        xanchor="left",
        x=0.01,
    ),
    annotations=annotations  # Add annotations to the layout
)

# Creating the figure
fig = go.Figure(data=traces, layout=layout)

# Exporting to JSON (if needed)
barplot_stacked_quarterly_vebrauch = fig.to_json()

# Show or save the plot
fig.show()
