from load_data.models import StromrechnungenDataAll
from load_data.models import StandortTransition
from django_pandas.io import read_frame
import datetime
import pandas as pd
import plotly.graph_objects as go
import math
import numpy as np
from timeit import default_timer as timer
from plotly.subplots import make_subplots

def monatliche_verbrauch_df():


    dataquery = StromrechnungenDataAll.objects.all()

    dataframe = read_frame(dataquery)

    # Sort data by date
    dataframe = dataframe.sort_values('Date')

    # Group by Year and Monat, and calculate the sum of Verbrauch_kWh
    df_grouped = dataframe.groupby(['Year', 'Monat']).agg({'Verbrauch_kWh': 'sum'}).reset_index()

    return df_grouped


def campus_verbrauch_df():
    dataquery_rechnungsdata = StromrechnungenDataAll.objects.all()

    dataframe_rechnungsdata = read_frame(dataquery_rechnungsdata)

    # Query to fetch only 'Zählpunkt' and 'Campus' columns
    dataquery_transitiontable = StandortTransition.objects.values_list('Zählpunkt', 'Campus')

    # Convert queryset to DataFrame with only 'Zählpunkt' and 'Campus' columns
    dataframe_transitiontable = read_frame(dataquery_transitiontable, fieldnames=['Zählpunkt', 'Campus'])

    dataframe_rechnungsdata = dataframe_rechnungsdata[['Year', 'Monat', 'Zählpunkt','Verbrauch_kWh']]

    dataframe_rechnungsdata=pd.merge(dataframe_rechnungsdata, dataframe_transitiontable, on='Zählpunkt')


    return dataframe_rechnungsdata

def gauge_plots():
    df_monthly = monatliche_verbrauch_df()

    month_names = {1: "Jan", 2: "Feb", 3: "Mär", 4: "Apr", 5: "Mai", 6: "Jun", 7: "Jul", 8: "Aug",
                   9: "Sep", 10: "Okt", 11: "Nov", 12: "Dez"}
    quarter_names = {1: "Q1", 2: "Q2", 3: "Q3", 4: "Q4"}

    quarters = {1: 1, 2: 1, 3: 1, 4: 2, 5: 2, 6: 2, 7: 3, 8: 3, 9: 3, 10: 4, 11: 4, 12: 4}
    df_monthly['Quarter'] = df_monthly['Monat'].map(quarters)

    # Group by Year and Quarter, and sum the consumption for each quarter
    df_quarterly = df_monthly.groupby(['Year', 'Quarter'])['Verbrauch_kWh'].sum().reset_index()

    last_year = datetime.datetime.now().year - 1
    df_average_monthly = df_monthly[(df_monthly['Year'] >= last_year - 5) & (df_monthly['Year'] < last_year)]
    df_average_monthly = df_average_monthly.groupby(['Monat']).agg({'Verbrauch_kWh': 'mean'}).reset_index()

    df_average_quarterly = df_quarterly[(df_quarterly['Year'] >=last_year - 5) & (df_quarterly['Year'] < last_year)]
    df_average_quarterly = df_average_quarterly.groupby(['Quarter']).agg({'Verbrauch_kWh': 'mean'}).reset_index()

    df_monthly['Verbrauch_kWh'] = df_monthly['Verbrauch_kWh']/1000000
    df_average_monthly['Verbrauch_kWh'] = df_average_monthly['Verbrauch_kWh'] / 1000000

    # Replace month numbers with names
    fig_monthly = go.Figure()

    fig_monthly.add_trace(go.Indicator(
        mode="gauge+number+delta",
        value=df_monthly.Verbrauch_kWh.iloc[-1],
        number={"suffix": "GWh"},
        domain={'x': [0, 1], 'y': [0, 1]},
        title={'text': "Verbrauch"},
        delta={'reference': df_average_monthly.Verbrauch_kWh.iloc[-1] ,"suffix": "GWh", 'increasing': {'color': "red"}, 'decreasing': {'color': "green"}},
        gauge={
            'axis': {'range': [None, math.ceil(df_average_monthly.Verbrauch_kWh.max())],"ticksuffix": "GWh", 'tickwidth': 1, 'tickcolor': "darkblue"},
            'bar': {'color': "green"},
            'bgcolor': "white",
            'borderwidth': 2,
            'bordercolor': "gray",
            'steps': [
                {'range': [0, df_average_monthly.Verbrauch_kWh.min()], 'color': 'lightgreen'},
                {'range': [df_average_monthly.Verbrauch_kWh.min(), df_average_monthly.Verbrauch_kWh.max()], 'color': 'orange'},
                {'range': [df_average_monthly.Verbrauch_kWh.max(), math.ceil(df_average_monthly.Verbrauch_kWh.max())], 'color': 'red'}],
            'threshold': {
                'line': {'color': "red", 'width': 4},
                'thickness': 0.75,
                'value': df_average_monthly.Verbrauch_kWh.max()}}
    ))

    fig_monthly.add_annotation(x=0.5, y=0.55,
                   text=f"{month_names[df_monthly.Monat.iloc[-1]]} {df_monthly.Year.iloc[-1]}",
                   xref="paper",
                   yref="paper",
                   showarrow=False)

    fig_monthly.update_layout(
        margin=dict(l=50, r=50, t=20, b=10),
    )


    df_quarterly['Verbrauch_kWh'] = df_quarterly['Verbrauch_kWh']/1000000
    df_average_quarterly['Verbrauch_kWh'] = df_average_quarterly['Verbrauch_kWh'] / 1000000

    # Replace month numbers with names
    fig_quarterly = go.Figure()

    fig_quarterly.add_trace(go.Indicator(
        mode="gauge+number+delta",
        value=df_quarterly.Verbrauch_kWh.iloc[-1],
        number={"suffix": "GWh"},
        domain={'x': [0, 1], 'y': [0, 1]},
        title={'text': "", 'font': {'size': 1}},
        delta={'reference': df_average_quarterly.Verbrauch_kWh.iloc[-1] ,"suffix": "GWh", 'increasing': {'color': "red"}, 'decreasing': {'color': "green"}},
        gauge={
            'axis': {'range': [None, math.ceil(df_average_quarterly.Verbrauch_kWh.max())],"ticksuffix": "GWh", 'tickwidth': 1, 'tickcolor': "darkblue"},
            'bar': {'color': "green"},
            'bgcolor': "white",
            'borderwidth': 2,
            'bordercolor': "gray",
            'steps': [
                {'range': [0, df_average_quarterly.Verbrauch_kWh.min()], 'color': 'lightgreen'},
                {'range': [df_average_quarterly.Verbrauch_kWh.min(), df_average_quarterly.Verbrauch_kWh.max()], 'color': 'orange'},
                {'range': [df_average_quarterly.Verbrauch_kWh.max(), math.ceil(df_average_quarterly.Verbrauch_kWh.max())], 'color': 'red'}],
            'threshold': {
                'line': {'color': "red", 'width': 4},
                'thickness': 0.75,
                'value': df_average_quarterly.Verbrauch_kWh.max()}}
    ))

    fig_quarterly.add_annotation(x=0.5, y=0.55,
                   text=f"{quarter_names[df_quarterly.Quarter.iloc[-1]]} {df_quarterly.Year.iloc[-1]}",
                   xref="paper",
                   yref="paper",
                   showarrow=False)

    fig_quarterly.update_layout(
        margin=dict(l=50, r=50, t=10, b=10),
    )

    gauge_plot_monthly = fig_monthly.to_json()
    gauge_plot_quarterly = fig_quarterly.to_json()

    return [gauge_plot_monthly, gauge_plot_quarterly]

def bubble_plot():
    month_names = {1: "Jan", 2: "Feb", 3: "Mär", 4: "Apr", 5: "Mai", 6: "Jun", 7: "Jul", 8: "Aug",
                   9: "Sep", 10: "Okt", 11: "Nov", 12: "Dez"}

    df_grouped = monatliche_verbrauch_df()
    # get average from last five years
    last_year = datetime.datetime.now().year - 1
    df_average = df_grouped[(df_grouped['Year'] >= last_year - 5) & (df_grouped['Year'] < last_year)]
    df_average = df_average.groupby(['Monat']).agg({'Verbrauch_kWh': 'mean'}).reset_index()
    df_average['Year'] = "Durchschnitt"

    df_grouped = df_grouped[(df_grouped['Year'] >= datetime.datetime.now().year - 11) & (df_grouped['Year'] <= datetime.datetime.now().year)]

    df_grouped = pd.concat([df_grouped, df_average], ignore_index=True)

    # Define bubble size and color based on sum
    # df_grouped['bubble_size'] = df_grouped['Verbrauch_kWh'] * 0.01  # Adjust the scaling factor as needed
    # df_grouped['bubble_color'] = ['red' if x > df_grouped['Verbrauch_kWh'].mean() else 'green' for x in
    #                              df_grouped['Verbrauch_kWh']]

    #df_grouped['Date'] = pd.to_datetime(df_grouped['Year'].astype(str) + '-' + df_grouped['Monat'].astype(str), format='%Y-%m')

    # Replace month numbers with names
    df_grouped['Monat'] = df_grouped['Monat'].map(month_names)

    df_grouped['Verbrauch_kWh'] =df_grouped['Verbrauch_kWh']/1000000

    fig = go.Figure()

    # Replace 'Durchschnitt' with a numerical value for plotting on the y-axis
    df_grouped['Year'] = df_grouped['Year'].replace('Durchschnitt', datetime.datetime.now().year+1)

    fig.add_trace(go.Scatter(
        x=df_grouped['Monat'],
        y=df_grouped['Year'],
        mode='markers',
        marker=dict(
            size=(df_grouped['Verbrauch_kWh'] * 30) / df_grouped['Verbrauch_kWh'].max(),
            color=df_grouped['Verbrauch_kWh'],
            colorbar=dict(title="GWh",thickness=8),
            colorscale='Jet',
            opacity=0.8
        ),
        text=df_grouped['Verbrauch_kWh'] ,
        hovertemplate='%{text} GWh',
        name="Verbrauch"
    ))

    # Add 'Durchschnitt' to the y-axis label
    fig.update_layout(
        yaxis=dict(
            tickvals=df_grouped['Year'].unique(),
            ticktext=df_grouped['Year'].replace(datetime.datetime.now().year+1, 'Durchschnitt').unique(),
        )
    )

    fig.update_layout(title='Monatliche Verbrauch',
        xaxis=dict(
            autotypenumbers='strict',
            title='Monat',
            categoryorder='array',
            categoryarray=df_grouped['Monat'],
            showgrid=False
        ),
        yaxis=dict(
            showgrid=False
        ),
        showlegend=False,
        margin=dict(l=0, r=0, t=30, b=0),
        plot_bgcolor='rgba(0,0,0,0)',
    )

    bubble_plot = fig.to_json()

    return bubble_plot


def lineplot_verbrauch_schema():
    df_monthly = monatliche_verbrauch_df()

    month_names = {1: "Jan", 2: "Feb", 3: "Mär", 4: "Apr", 5: "Mai", 6: "Jun", 7: "Jul", 8: "Aug",
                   9: "Sep", 10: "Okt", 11: "Nov", 12: "Dez"}

    last_year = datetime.datetime.now().year - 1
    df_average = df_monthly[(df_monthly['Year'] >= last_year - 5) & (df_monthly['Year'] < last_year)]
    df_average = df_average.groupby(['Monat']).agg({'Verbrauch_kWh': 'mean'}).reset_index()

    dict_average = dict(zip(df_average.Monat.tolist(), df_average.Verbrauch_kWh.tolist()))
    df_monthly['Average'] = df_monthly.Monat.map(dict_average)

    # Concatenate 'Year' and 'Monat' columns as strings
    df_monthly['Date'] = pd.to_datetime(df_monthly['Year'].astype(str) + '-' + df_monthly['Monat'].astype(str),
                                        format='%Y-%m')



    fig = go.Figure()

    df_monthly['Average'] = df_monthly['Average'] / 1000000
    df_monthly['Verbrauch_kWh'] = df_monthly['Verbrauch_kWh']/1000000
    # Adding scatter trace
    fig.add_trace(go.Scatter(x=df_monthly['Date'],
                             y=df_monthly['Average'],
                             fill='tozeroy',
                             mode='none',
                             fillcolor='rgba(168, 216, 234, 0.5)',
                             showlegend=False))

    # Define a list of Tableau colors
    tableau_colors = [
        '#e6194b', '#3cb44b', '#ffe119', '#4363d8', '#f58231', '#911eb4', '#46f0f0', '#f032e6', '#bcf60c', '#fabebe', '#008080', '#e6beff'
    ]

    for i, year in enumerate(df_monthly['Year'].unique()):
        # Filter the data for the current year
        data_year = df_monthly[df_monthly['Year'] == year]

        # Add a trace for the current year with a different color
        fig.add_trace(
            go.Scatter(
                x=data_year['Date'],
                y=data_year['Verbrauch_kWh'],
                mode='lines',
                name=str(year),  # Set the name of the trace to the year
                line=dict(color=tableau_colors[i % len(tableau_colors)], width=2)  # Use a different color for each iteration
            )
        )

    # Add range slider
    fig.update_layout(
        xaxis=dict(
            rangeselector=dict(
                buttons=list([
                    dict(count = 3,
                         label = "3 Monat",
                         step = "month",
                         stepmode = "backward"),
                    dict(count = 6,
                         label = "6 Monat",
                         step = "month",
                         stepmode = "backward"),
                    dict(count = 1,
                         label = "1 Jahr",
                         step = "year",
                         stepmode = "backward"),
                    dict(count = 1,
                         label = "Jahr bis Jetzt",
                         step = "year",
                         stepmode = "todate"),
                    dict(step="all")
                ])
            ),
            rangeslider=dict(
                visible=True
            ),
            type="date"
        )
    )

    fig.update_layout(title='Verbrauch-Pattern',
        margin=dict(l=0, r=0, t=60, b=0),
        yaxis_ticksuffix="GWh",
        yaxis_showticksuffix="all",  # or "first" or "last"
        plot_bgcolor='rgba(0,0,0,0)',
        legend=dict(
              orientation="h",
              yanchor="bottom",
              y=0,
              xanchor="left",
              x=0,
              bgcolor= 'rgba(0,0,0,0)'),
              xaxis=dict(gridcolor='lightgrey',dtick="M12",tickformat="%Y"),
              showlegend=False
              #yaxis=dict(gridcolor='lightgrey'),
    )

    plot_verbrauch_schema = fig.to_json()

    return plot_verbrauch_schema


def donutchart_campus_verbrauch():

    dataframe_rechnungsdata = campus_verbrauch_df()

    last_year = datetime.datetime.now().year - 1
    dataframe_rechnungsdata = dataframe_rechnungsdata[(dataframe_rechnungsdata['Year'] >= last_year - 5) & (dataframe_rechnungsdata['Year'] < last_year)]

    dataframe_rechnungsdata_grouped = dataframe_rechnungsdata.groupby(['Campus']).agg(
        {'Verbrauch_kWh': 'sum'}).reset_index()

    # Calculate total
    total = dataframe_rechnungsdata_grouped['Verbrauch_kWh'].sum()

    # Calculate proportions
    dataframe_rechnungsdata_grouped['Proportion'] = dataframe_rechnungsdata_grouped['Verbrauch_kWh'] / total

    # Combine values less than 5% into "Other"
    threshold = 0.05
    dataframe_rechnungsdata_grouped.loc[dataframe_rechnungsdata_grouped['Proportion'] < threshold, 'Campus'] = 'Other'
    dataframe_rechnungsdata_grouped = dataframe_rechnungsdata_grouped.groupby('Campus').sum().reset_index()

    # Plotly pie chart
    fig = go.Figure(data=[go.Pie(labels=dataframe_rechnungsdata_grouped['Campus'], values=dataframe_rechnungsdata_grouped['Verbrauch_kWh'], hole=.3, textinfo='label+percent', insidetextfont=dict(size=10))])
    fig.update_layout(title='Campus Verbrauch',
                      margin=dict(l=0, r=0, b=0, t=30),
                      showlegend=False)

    donutchart_campus_verbrauch = fig.to_json()

    return donutchart_campus_verbrauch

def lineplot_yearly_campus_verbrauch():
    dataframe_rechnungsdata = campus_verbrauch_df()

    dataframe_rechnungsdata_grouped = dataframe_rechnungsdata.groupby(['Campus']).agg(
        {'Verbrauch_kWh': 'sum'}).reset_index()

    # Sorting the DataFrame by 'Verbrauch_kWh' column in descending order
    dataframe_rechnungsdata_grouped = dataframe_rechnungsdata_grouped.sort_values(by='Verbrauch_kWh', ascending=False)

    # Selecting the top 4 campuses
    top_campuses = dataframe_rechnungsdata_grouped['Campus'][:4].tolist()

    # Replace all other Campus except top 4 with Other
    dataframe_rechnungsdata['Campus'] = np.where(dataframe_rechnungsdata['Campus'].isin(top_campuses),
                                                 dataframe_rechnungsdata['Campus'], 'Other')

    dataframe_rechnungsdata = dataframe_rechnungsdata.groupby(['Year','Campus']).agg(
        {'Verbrauch_kWh': 'sum'}).reset_index()


    # Create a figure
    fig = go.Figure()

    # Create a list of unique campuses

    top_campuses.append('Other')

    dataframe_rechnungsdata['Verbrauch_kWh'] = dataframe_rechnungsdata['Verbrauch_kWh']/1000000

    # Iterate over each campus
    for campus in top_campuses:
        # Filter the DataFrame for the current campus
        campus_df = dataframe_rechnungsdata[dataframe_rechnungsdata['Campus'] == campus]
        # Add a line trace for the current campus
        fig.add_trace(go.Scatter(x=campus_df['Year'], y=campus_df['Verbrauch_kWh'], mode='lines', name=campus, line=dict(width=2)))

    # Update layout
    fig.update_layout(title='Jahrliche Verbrauch',
                      xaxis_title='Year',
                      yaxis_title='Verbrauch GWh',
                      margin=dict(l=0, r=0, b=0, t=30),
                      legend=dict(
                          orientation="v",
                          yanchor="top",
                          y=0.99,
                          xanchor="left",
                          x=0.01,
                      #    bgcolor= 'rgba(0,0,0,0)'
                      ),
                      plot_bgcolor='rgba(0,0,0,0)',
                      xaxis=dict(gridcolor='lightgrey',dtick=1),
                      yaxis=dict(gridcolor='lightgrey'),
                      )

    lineplot_yearly_campus_verbrauch =fig.to_json()

    return lineplot_yearly_campus_verbrauch

def barplot_stacked_quarterly_vebrauch():
    quarter_names = {1: "Q1", 2: "Q2", 3: "Q3", 4: "Q4"}

    df_monthly = monatliche_verbrauch_df()
    df_monthly['Quarter'] = df_monthly['Monat'].map(quarter_names)

    # Group by Year and Quarter, and sum the consumption for each quarter
    df_quarterly = df_monthly.groupby(['Year', 'Quarter'])['Verbrauch_kWh'].sum().reset_index()

    df_quarterly=df_monthly.groupby(['Year', 'Quarter']).agg(
        {'Verbrauch_kWh': 'sum'}).reset_index()

    # Calculate total consumption for each year
    df_yearly_total = df_quarterly.groupby('Year')['Verbrauch_kWh'].sum().reset_index()

    # Convert Verbrauch_kWh to GWh
    df_quarterly['Verbrauch_kWh'] /= 1000000
    df_yearly_total['Verbrauch_kWh'] /= 1000000

    # Getting the years
    years = df_quarterly['Year'].unique()

    # Getting the quarters
    quarters = df_quarterly['Quarter'].unique()

    # Creating traces for each quarter
    traces = []
    for quarter in quarters:
        # Filter the DataFrame for the current quarter
        quarter_data = df_quarterly[df_quarterly['Quarter'] == quarter]

        trace = go.Bar(
            x=quarter_data['Year'],
            y=quarter_data['Verbrauch_kWh'],
            name=quarter
        )
        traces.append(trace)

    # Adding total consumption annotations
    annotations = []
    for year in years:
        total_consumption = df_yearly_total[df_yearly_total['Year'] == year]['Verbrauch_kWh'].values[0]
        annotation = dict(
            x=year,
            y=total_consumption + 0.5,  # Adjust position for annotation
            xref="x",
            yref="y",
            text=f"{total_consumption:.2f}",
            showarrow=False,
            font=dict(
                size=8,
                color="black"
            )
        )
        annotations.append(annotation)

    # Creating the layout
    layout = go.Layout(
        title='Vierteljährlicher Stromverbrauch',
        xaxis=dict(title='Year', dtick=1),
        yaxis=dict(title='Verbrauch [GWh]'),
        barmode='stack',
        margin=dict(l=0, r=0, b=50, t=30),  # Adjust bottom margin for annotations
        plot_bgcolor='rgba(0,0,0,0)',
        legend=dict(
            orientation="v",
            yanchor="top",
            y=0.99,
            xanchor="left",
            x=0.01,
        ),
        annotations=annotations  # Add annotations to the layout
    )

    # Creating the figure
    fig = go.Figure(data=traces, layout=layout)

    barplot_stacked_quarterly_vebrauch = fig.to_json()

    return barplot_stacked_quarterly_vebrauch

