
def overview(request):
    filtered_data = StromrechnungenDataAll.objects.filter(Adresse="Argentinierstraße 8")

    # Query data from the database
    data = StromrechnungenDataAll.objects.filter(Adresse="Argentinierstraße 8")

    # Extract relevant data for plotting
    dates = [entry.Date for entry in data]
    consumption = [entry.Verbrauch_kWh for entry in data]

    # Create Plotly trace for the line plot
    trace = go.Scatter(x=dates, y=consumption, mode='lines', name='Consumption (kWh)')
    layout = go.Layout(title='Consumption Time Series', xaxis=dict(title='Date'), yaxis=dict(title='Consumption (kWh)'))
    figure = go.Figure(data=[trace], layout=layout)

    # Convert Plotly figure to JSON format
    plot_div = figure.to_json()


    ################

    dataquery = StromrechnungenDataAll.objects.filter(Adresse="Argentinierstraße 8")
    dataframe = read_frame(dataquery)

    # Group by Year and Monat, and calculate the sum of Verbrauch_kWh
    df_grouped = dataframe.groupby(['Year', 'Monat']).agg({'Verbrauch_kWh': 'sum'}).reset_index()

    # Define bubble size and color based on sum
    df_grouped['bubble_size'] = df_grouped['Verbrauch_kWh'] * 0.01  # Adjust the scaling factor as needed
    df_grouped['bubble_color'] = ['red' if x > df_grouped['Verbrauch_kWh'].mean() else 'green' for x in
                                  df_grouped['Verbrauch_kWh']]

    # Prepare data for Chart.js
    labels = df_grouped.apply(lambda x: f"{x['Monat']}/{x['Year']}", axis=1).tolist()
    bubble_sizes = df_grouped['bubble_size'].tolist()
    bubble_colors = df_grouped['bubble_color'].tolist()



    context = {'filtered_data': filtered_data,'plot_div': plot_div, 'labels': labels, 'bubble_sizes': bubble_sizes, 'bubble_colors': bubble_colors}

    return render(request, 'overview.html', context)

