from django.shortcuts import render
import folium
from folium.plugins import MarkerCluster
from load_data.models import LocationData
from django_pandas.io import read_frame
from map.functions import kpi_map_marker
import pandas as pd
import altair as alt
import plotly.graph_objects as go
import math
import branca

def show_map(request):

    dataquery = LocationData.objects.all()

    marker_data = read_frame(dataquery)

    kpi_data = kpi_map_marker()

    marker_data = pd.merge(marker_data, kpi_data, left_on='Zaehlpunkt', right_on='zaehlpunkt', how='left')

    marker_data = marker_data.fillna(0)

    # Replace the substring in Zaehlpunkt with '...'
    marker_data['Zaehlpunkt'] = marker_data['Zaehlpunkt'].str.replace('000000000000001000', '...')

    # Define the base URL for the basemap.at service
    base_url = "http://maps.wien.gv.at/basemap/bmapgrau/normal/google3857/{z}/{y}/{x}.png"

    # Define the available layers and their names
    # layers = {
    #     "bmapgrau": "Gray",
    #     "geolandbasemap": "Basemap",
    #     "bmapoverlay": "Overlay",
    #     "bmaporthofoto30cm": "Orthophoto",
    #     "bmapgelaende": "Terrain",
    #     "bmapoberflaeche": "Surface"
    # }

    # Create a new map with Folium
    m = folium.Map(width="100%", height="75%", location=[48.2082, 16.3738], zoom_start=12, control_scale=False, tiles = None)


    folium.TileLayer(tiles=base_url, attr="basemap.at", name="Gray").add_to(m)

    # # Add the TileLayers for each layer
    # for layer, name in layers.items():
    #     url = base_url.format(layer)
    #     folium.TileLayer(tiles=url, attr="basemap.at", name=name).add_to(m)

    # Initialize MarkerCluster to group nearby markers
    marker_cluster = MarkerCluster().add_to(m)

    # Dictionary to keep track of marker counts at each location
    marker_counts = {}

    # Loop through DataFrame rows using iterrows()
    for index, row in marker_data.iterrows():
        Zaehlpunkt = row['Zaehlpunkt']
        lat = row['Latitude']
        lon = row['Longitude']
        location = (lat, lon)
        Address = row['Address']
        Code = row['Code']
        font_size = 2.5 * 30 // (len(Code)+1)   # Adjust the range (8 to 12) as needed
        ###############
        data = row.to_dict()

        max_verbrauch = max([data['durchschnittliche_verbrauch_monatlich_max'],
                                           data['aktueller_monatsverbrauch']])

        if max_verbrauch!=0 :
            exponent = math.floor(math.log10(abs(max_verbrauch)))
        else:
            exponent = 1

        data['verbrauch_monatlich_max'] = (int(str(max_verbrauch)[0])+1)*10**exponent



        #data = {
        #    'aktueller_monatsverbrauch': 500,
        #    'durchschnittliche_verbrauch_monatlich_min': 200,
        #    'durchschnittliche_verbrauch_monatlich_max': 800,
        #    'verbrauch_monatlich_max': 1000
        #}

        # Create a DataFrame from the data
        df = pd.DataFrame(data, index=[0])

        # Calculate values for stacked bars
        df['1.Durchschnittliche Min'] = df['durchschnittliche_verbrauch_monatlich_min']
        df['2.Durchschnittliche Max'] = df['durchschnittliche_verbrauch_monatlich_max'] - df[
            '1.Durchschnittliche Min']
        df['3.Maximum'] = df['verbrauch_monatlich_max'] - df['2.Durchschnittliche Max']

        # Melt the DataFrame to transform it into long format for plotting
        df_melted = df.melt(value_vars=['1.Durchschnittliche Min', '2.Durchschnittliche Max','3.Maximum'], var_name='category', value_name='kWh')

        #leg_order = ['segment_1', 'segment_2', 'segment_3']
        # Define the base stacked bar chart with inverted stacking order
        base = alt.Chart(df_melted, title='Verbrauch dieser Monat').mark_bar().encode(
            alt.X('kWh:Q', stack='zero'),  # Invert stacking order based on color
            color=alt.Color('category:N', #sort=leg_order,
                            scale=alt.Scale(
                                #domain=leg_order,
                                #domain=['Durchschnittliche Min', 'Durchschnittliche Max', 'Maximum'],
                                range=['green', 'orange', 'red']
                                ),
                            legend=alt.Legend(title='',
                                              orient='none',
                                              legendY=55,
                                              direction='horizontal'
                                              ))
        )

        # Overlay the stacked bar chart with the aktueller_monatsverbrauch
        df_melt = df.melt(value_vars=['aktueller_monatsverbrauch'], var_name='category', value_name='kWh')
        overlay = alt.Chart(df_melt).mark_bar(size=10).encode(
            alt.X('kWh:Q', stack='zero'),
            color=alt.value('blue'),  # Set the color directly to blue
            opacity=alt.value(1)
        )

        # Combine the base and overlay
        chart = (base + overlay)

        iframe = folium.IFrame(chart.to_html(), width=300, height=300)

        data = alt.Data(values=[{'x': 'A'}])
        footer= [ f'Zaehlpunkt: {Zaehlpunkt}',f'Address: {Address}','',
                'Verbrauch [kWh]',
                f'Letzter Monat: {row.verbrauch_taeglich_last_month}',
                f'Letztes Quartal: {row.verbrauch_taeglich_last_quarter}',
                f'Letztes Jahr: {row.verbrauch_taeglich_last_year}',
                f'Gestern: {row.verbrauch_taeglich_yesterday}' ]
        text = (
            alt.Chart(data)
            .mark_text(text=footer, x=0, y='height', dx=0, dy=70, align='left', fontSize= 18)
        )

        chart = alt.layer(chart, text)



        vega_lite = folium.VegaLite(
            chart,
            width="100%",
            height="100%",
        )

        popup = folium.Popup().add_child(vega_lite)

        # Define custom marker UI (SVG icon)
        marker_ui = f"""
                    <div>
                      <svg width="100" height="100">
                        <circle cx="50" cy="50" r="30" fill="white" opacity=".6"/>
                        <circle cx="50" cy="50" r="25" fill="#5485AB" opacity="1"/>
                        <text x="50%" y="50%" dominant-baseline="middle" text-anchor="middle" fill="#E9F1F0" font-size="{font_size}px">{Code}</text>
                      </svg>
                    </div>
                    """

        # Create marker with custom popup and UI, and add to marker cluster
        folium.Marker(location=location, popup=popup, icon=folium.DivIcon(html=marker_ui), lazy=True).add_to(marker_cluster)




    # Render the map directly into the template and return it as a response
    return render(request, 'map.html', {'map': m._repr_html_()})
