import pandas as pd
import altair as alt

# Define the data
data = {
    'aktueller_monatsverbrauch': 500,
    'durchschnittliche_verbrauch_monatlich_min': 200,
    'durchschnittliche_verbrauch_monatlich_max': 800,
    'verbrauch_monatlich_max': 1000
}

# Create a DataFrame from the data
df = pd.DataFrame(data, index=[0])

# Calculate values for stacked bars
df['segment_1'] = df['durchschnittliche_verbrauch_monatlich_min']
df['segment_2'] = df['durchschnittliche_verbrauch_monatlich_max'] - df['durchschnittliche_verbrauch_monatlich_min']
df['segment_3'] = df['verbrauch_monatlich_max'] - df['durchschnittliche_verbrauch_monatlich_max']

# Melt the DataFrame to transform it into long format for plotting
df_melted = df.melt(value_vars=['segment_1', 'segment_2', 'segment_3'], var_name='category', value_name='value')

leg_order = ['segment_1', 'segment_2', 'segment_3']
# Define the base stacked bar chart with inverted stacking order
base = alt.Chart(df_melted).mark_bar().encode(
    alt.X('value:Q', stack='zero'),  # Invert stacking order based on color
    color=alt.Color('category:N', sort=leg_order,
                    scale=alt.Scale(range=['green', 'orange', 'red']),
                    legend=alt.Legend(title='',
orient='none',
                                      legendY=55,
                                      direction='horizontal'
                                      ))
)

# Overlay the stacked bar chart with the aktueller_monatsverbrauch
df_melt = df.melt(value_vars=['aktueller_monatsverbrauch'], var_name='category', value_name='value')
overlay = alt.Chart(df_melt).mark_bar(size=10).encode(
    alt.X('value:Q', stack='zero'),
    color=alt.value('blue'),  # Set the color directly to blue
    opacity=alt.value(1)
)

# Combine the base and overlay
chart = base + overlay

# Configure chart properties
#chart = chart.properties(
#    width=15,  # Set chart width
#    height=300,  # Set chart height
#    title='Stacked Bar Chart with Overlay'  # Set chart title
#)

# Add legend for the base chart
#chart = chart.configure_legend(
#    strokeColor='gray',    # Customize legend stroke color
#    fillColor='#EEEEEE',   # Customize legend fill color
#    padding=10             # Add padding to legend
#)

# Save the chart as an HTML file
chart_file_path = 'stacked_bar_chart.html'
chart.save(chart_file_path)
