from map.functions import kpi_map_marker
import plotly.graph_objects as go
from map.functions import average_monnatliche_verbrauch
import math

def gauge_plot_map_marker():
    merged_consumption = kpi_map_marker()
    average_monnatliche_verbrauch=average_monnatliche_verbrauch()

    average_monnatliche_verbrauch =average_monnatliche_verbrauch[average_monnatliche_verbrauch['obiscode'].isin(['1-1:1.8.0','1-1:1.9.0'])]

    # Replace month numbers with names
    fig_monthly = go.Figure()

    fig_monthly.add_trace(go.Indicator(
        mode="gauge+number+delta",
        value=df_monthly.Verbrauch_kWh.iloc[-1],
        number={"suffix": "GWh"},
        domain={'x': [0, 1], 'y': [0, 1]},
        title={'text': "Verbrauch"},
        delta={'reference': df_average_monthly.Verbrauch_kWh.iloc[-1] ,"suffix": "GWh", 'increasing': {'color': "red"}, 'decreasing': {'color': "green"}},
        gauge={
            'axis': {'range': [None, math.ceil(df_average_monthly.Verbrauch_kWh.max())],"ticksuffix": "GWh", 'tickwidth': 1, 'tickcolor': "darkblue"},
            'bar': {'color': "green"},
            'bgcolor': "white",
            'borderwidth': 2,
            'bordercolor': "gray",
            'steps': [
                {'range': [0, df_average_monthly.Verbrauch_kWh.min()], 'color': 'lightgreen'},
                {'range': [df_average_monthly.Verbrauch_kWh.min(), df_average_monthly.Verbrauch_kWh.max()], 'color': 'orange'},
                {'range': [df_average_monthly.Verbrauch_kWh.max(), math.ceil(df_average_monthly.Verbrauch_kWh.max())], 'color': 'red'}],
            'threshold': {
                'line': {'color': "red", 'width': 4},
                'thickness': 0.75,
                'value': df_average_monthly.Verbrauch_kWh.max()}}
    ))

    fig_monthly.add_annotation(x=0.5, y=0.55,
                   text=f"{month_names[df_monthly.Monat.iloc[-1]]} {df_monthly.Year.iloc[-1]}",
                   xref="paper",
                   yref="paper",
                   showarrow=False)

    fig_monthly.update_layout(
        margin=dict(l=50, r=50, t=20, b=10),
    )