import pandas as pd
from load_data.models import WienerNetztePortalData
from django_pandas.io import read_frame
from datetime import datetime


def get_wiener_netzte_portal_data():

    dataquery = WienerNetztePortalData.objects.all()

    wiener_netzte_data = read_frame(dataquery)

    wiener_netzte_data = wiener_netzte_data[
        wiener_netzte_data['obiscode'].isin(['1-1:1.8.0', '1-1:1.9.0'])]

    # Convert 'zeitvon' column to datetime
    wiener_netzte_data['zeitbis'] = pd.to_datetime(wiener_netzte_data['zeitbis'])

    # Sort DataFrame by 'zaehlpunkt', 'obiscode', and 'zeitvon'
    wiener_netzte_data.sort_values(by=['zaehlpunkt', 'obiscode', 'zeitbis'], inplace=True)

    # Calculate daily consumption (verbrauch_taeglich) for each meter and obiscode
    wiener_netzte_data['verbrauch_taeglich'] = wiener_netzte_data.groupby(['zaehlpunkt', 'obiscode'])['messwert'].diff()

    wiener_netzte_data['verbrauch_taeglich'] = wiener_netzte_data['verbrauch_taeglich'] / 1000

    return wiener_netzte_data

def durchschnittliche_monatlich_verbrauch():

    daily_data = get_wiener_netzte_portal_data()

    daily_data = daily_data[
        daily_data['obiscode'].isin(['1-1:1.8.0', '1-1:1.9.0'])]

    # Extract month-year from 'zeitvon' for grouping
    daily_data['month_year'] = daily_data['zeitbis'].dt.to_period('M')

    # Group by 'zaehlpunkt', 'obiscode', and month-year
    grouped = daily_data.groupby(['zaehlpunkt', 'obiscode', 'month_year'])

    # Filter months with complete data (no missing days)
    complete_months = grouped.filter(lambda x: len(x) == x['zeitbis'].dt.days_in_month.unique()[0])

    # Calculate average daily consumption for each complete month
    average_verbrauch = complete_months.groupby(['zaehlpunkt', 'obiscode', 'month_year'])[
        'verbrauch_taeglich'].sum().reset_index()

    # Extract just the month from 'zeitbis' and assign to a new 'month' column
    average_verbrauch['month_year'] = average_verbrauch['month_year'].dt.month  # %B gives full month name (e.g., January)


    # Calculate average daily consumption for each complete month
    average_verbrauch = average_verbrauch.groupby(['zaehlpunkt', 'obiscode', 'month_year'])[
        'verbrauch_taeglich'].mean().reset_index()

    average_verbrauch.rename(columns={'verbrauch_taeglich': 'durchschnittliche_verbrauch_monatlich','month_year':'month'}, inplace=True)

    return average_verbrauch

def kpi_map_marker():
    daily_data = get_wiener_netzte_portal_data()

    daily_data = daily_data[
        daily_data['obiscode'].isin(['1-1:1.8.0', '1-1:1.9.0'])]

    # Calculate the current date and the start of the last month, last quarter, and last year
    current_date = pd.Timestamp.now()

    last_month_start = (current_date - pd.DateOffset(months=1)).replace(day=1)
    last_quarter_start = (current_date - pd.DateOffset(months=3)).replace(day=1)
    last_year_start = (current_date - pd.DateOffset(years=1)).replace(day=1)

    last_month_end = current_date - pd.DateOffset(days=current_date.day)  # End of last month
    last_quarter_end = current_date - pd.DateOffset(days=current_date.day)  # End of last quarter
    last_year_end = current_date - pd.DateOffset(days=current_date.day)  # End of last year

    # Calculate yesterday's date
    yesterday = current_date - pd.DateOffset(days=1)

    # Filter data for the last month, last quarter, last year, and yesterday
    last_month_data = daily_data[(daily_data['zeitbis'] >= last_month_start) & (daily_data['zeitbis'] <= last_month_end)]
    last_quarter_data = daily_data[(daily_data['zeitbis'] >= last_quarter_start) & (daily_data['zeitbis'] <= last_quarter_end)]
    last_year_data = daily_data[(daily_data['zeitbis'] >= last_year_start) & (daily_data['zeitbis'] <= last_year_end)]
    yesterday_data = daily_data[daily_data['zeitbis'].dt.date == yesterday.date()]

    # Calculate total consumption for the last month, last quarter, last year, and yesterday for each zaehlpunkt
    consumption_last_month = last_month_data.groupby('zaehlpunkt')['verbrauch_taeglich'].sum().reset_index()
    consumption_last_quarter = last_quarter_data.groupby('zaehlpunkt')['verbrauch_taeglich'].sum().reset_index()
    consumption_last_year = last_year_data.groupby('zaehlpunkt')['verbrauch_taeglich'].sum().reset_index()
    consumption_yesterday = yesterday_data.groupby('zaehlpunkt')['verbrauch_taeglich'].sum().reset_index()

    # Merge the dataframes based on the common column 'zaehlpunkt'
    merged_consumption = pd.merge(consumption_last_month, consumption_last_quarter, on='zaehlpunkt', how='outer',
                                  suffixes=('_last_month', '_last_quarter'))
    merged_consumption = pd.merge(merged_consumption, consumption_last_year, on='zaehlpunkt', how='outer',
                                  suffixes=('', '_last_year'))
    merged_consumption = pd.merge(merged_consumption, consumption_yesterday, on='zaehlpunkt', how='outer',
                                  suffixes=('_last_year', '_yesterday'))

    durchschnittliche_verbrauch=durchschnittliche_monatlich_verbrauch()

    durchschnittliche_verbrauch =durchschnittliche_verbrauch[durchschnittliche_verbrauch['obiscode'].isin(['1-1:1.8.0','1-1:1.9.0'])]

    durchschnittliche_verbrauch_min = durchschnittliche_verbrauch.groupby('zaehlpunkt')['durchschnittliche_verbrauch_monatlich'].min().reset_index()

    durchschnittliche_verbrauch_max = durchschnittliche_verbrauch.groupby('zaehlpunkt')['durchschnittliche_verbrauch_monatlich'].max().reset_index()

    merged_consumption = pd.merge(merged_consumption, durchschnittliche_verbrauch_max, on='zaehlpunkt', how='outer',
                                  suffixes=('', '_max'))
    merged_consumption = pd.merge(merged_consumption, durchschnittliche_verbrauch_min, on='zaehlpunkt', how='outer',
                                  suffixes=('_max', '_min'))

    # Get the current month and year
    current_date = datetime.now()
    current_month = current_date.month
    current_year = current_date.year

    # Calculate the start date of the current month
    first_day_of_month = datetime(current_year, current_month, 1)

    # Filter data for the current month using __gte lookup
    dataquery = WienerNetztePortalData.objects.filter(zeitbis__gte=first_day_of_month)

    current_month_data = read_frame(dataquery)

    current_month_data = current_month_data[
        current_month_data['obiscode'].isin(['1-1:1.8.0', '1-1:1.9.0'])]

    # Calculate daily consumption (verbrauch_taeglich) for each meter and obiscode
    current_month_data['verbrauch_taeglich'] = current_month_data.groupby(['zaehlpunkt', 'obiscode'])['messwert'].diff()

    current_month_data['verbrauch_taeglich'] = current_month_data['verbrauch_taeglich']/1000

    current_month_data=current_month_data.groupby(['zaehlpunkt'])[
        'verbrauch_taeglich'].sum().reset_index()

    current_month_data=current_month_data.rename(columns={'verbrauch_taeglich': 'aktueller_monatsverbrauch'})

    merged_consumption = pd.merge(merged_consumption, current_month_data, on='zaehlpunkt', how='outer')

    return merged_consumption