from django.test import TestCase
from django.db import models
from load_data.models import StromrechnungenDataAll
import pandas as pd
from django_pandas.io import read_frame
import plotly.graph_objs as go
import datetime
# Create your tests here.

# Dictionary mapping month numbers to names
month_names = {1: "Januar", 2: "Februar", 3: "März", 4: "April", 5: "Mai", 6: "Juni", 7: "Juli", 8: "August", 9: "September", 10: "Oktober", 11: "November", 12: "Dezember"}

dataquery = StromrechnungenDataAll.objects.all()

dataframe = read_frame(dataquery)

# Sort data by date
dataframe = dataframe.sort_values('Date')

# Group by Year and Monat, and calculate the sum of Verbrauch_kWh
df_grouped = dataframe.groupby(['Year', 'Monat']).agg({'Verbrauch_kWh': 'sum'}).reset_index()

# get average from last five years
last_year = datetime.datetime.now().year - 1
df_average = df_grouped[(df_grouped['Year']>= last_year-5) & (df_grouped['Year']<last_year)]
df_average = df_average.groupby(['Monat']).agg({'Verbrauch_kWh': 'mean'}).reset_index()
df_average['Year'] = "Durchschnitt"

df_grouped = pd.concat([df_grouped,df_average], ignore_index=True)


# Define bubble size and color based on sum
#df_grouped['bubble_size'] = df_grouped['Verbrauch_kWh'] * 0.01  # Adjust the scaling factor as needed
#df_grouped['bubble_color'] = ['red' if x > df_grouped['Verbrauch_kWh'].mean() else 'green' for x in
#                              df_grouped['Verbrauch_kWh']]

# Replace month numbers with names
df_grouped['Monat'] = df_grouped['Monat'].map(month_names)

# Create Plotly scatter plot
fig = go.Figure(data=go.Scatter(
    x=df_grouped['Monat'],
    y=df_grouped['Year'],
    mode='markers',
    marker=dict(
        size=df_grouped['bubble_size'],
        color=df_grouped['bubble_color']
    )
))

fig.update_layout(
    title="Bubble Diagram",
    xaxis_title="Monat",
    yaxis_title="Year",
    showlegend=False
)

plot_div = fig.to_html(full_html=False, default_height=500, default_width=700)
