from django.db import models

class StromrechnungenDataAll(models.Model):
    Year = models.IntegerField(null=True)
    Monat = models.IntegerField(null=True)
    Day = models.IntegerField(null=True)
    Vertragskonto = models.BigIntegerField(null=True)
    Zählpunkt = models.CharField(max_length=255, primary_key=True)
    Adresse = models.CharField(max_length=255, null=True)
    Verbrauch_kWh = models.FloatField(null=True)
    Date = models.DateField(null=True)

    class Meta:
        db_table = 'stromrechnungen_data_all'
        app_label = 'load_data'
        managed = False

class StandortTransition(models.Model):

    Zählpunkt = models.CharField(max_length=255, primary_key=True)
    Vertragskonto = models.BigIntegerField(null=True)
    Adresse = models.CharField(max_length=255, null=True)
    Address_Original = models.CharField(max_length=255, null=True)
    Address_Code = models.CharField(max_length=255, null=True)
    Included = models.IntegerField(null=True)
    Area_code = models.CharField(max_length=255, null=True)
    Existence = models.IntegerField(null=True)
    Address_Name = models.CharField(max_length=255, null=True)
    Campus = models.CharField(max_length=255, null=True)
    Campus_Name = models.CharField(max_length=255, null=True)

    class Meta:
        db_table = 'standort_transition_table'
        app_label = 'load_data'
        managed = False

class LocationData(models.Model):
    Zaehlpunkt = models.CharField(max_length=255, primary_key=True)
    Latitude = models.FloatField(null=True)
    Longitude = models.FloatField(null=True)
    Address = models.CharField(max_length=255, null=True)
    Code = models.CharField(max_length=255, null=True)

    class Meta:
        db_table = 'location_data'
        app_label = 'load_data'
        managed = False

class WienerNetztePortalData(models.Model):
    zaehlpunkt = models.CharField(max_length=255, primary_key=True)
    zeitvon = models.DateTimeField(null=True)
    zeitbis = models.DateTimeField(null=True)
    obiscode = models.CharField(max_length=255,null=True)
    einheit = models.CharField(max_length=50,null=True)
    messwert = models.BigIntegerField(null=True)

    class Meta:

        db_table = 'wiener_netzte_portal_data'  # Name of the foreign table
        app_label = 'load_data'
        managed = False  # This model is backed by a database view or foreign table

