"""
URL configuration for edm_tuwien project.

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/5.0/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  path('', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  path('', Home.as_view(), name='home')
Including another URLconf
    1. Import the include() function: from django.urls import include, path
    2. Add a URL to urlpatterns:  path('blog/', include('blog.urls'))
"""
from django.contrib import admin
from django.conf.urls import include
from django.contrib.auth.views import LoginView
from django.urls import path
from load_data.views import show_data
from overview.views import overview
from test_app.views import test_plot
from map.views import show_map
from users.views import dashboard, register
#from users.views import ChangePasswordView, ChangePasswordDoneView, ResetPasswordView, ResetPasswordDoneView
#from users.views import ResetPasswordConfirmView, ResetPasswordCompleteView

urlpatterns = ([
    path("admin/", admin.site.urls),
    path("accounts/", include("django.contrib.auth.urls")),
    path("show", show_data, name="show_data"),
    path("overview", overview, name="overview"),
    path("test", test_plot, name="test"),
    path("map",show_map,name="map"),
    path("dashboard", dashboard, name="dashboard"),
    path("register", register, name="register"),
    # path("password-change", ChangePasswordView.as_view(), name="password-change"),
    # path("password-change/done/", ChangePasswordDoneView.as_view(), name='password-change-done'),
    # path("password-reset", ResetPasswordView.as_view(), name="password-reset"),
    # path("password-reset/done/", ResetPasswordDoneView.as_view(), name='password-reset-done'),
    # path("password-reset/confirm/", ResetPasswordConfirmView.as_view(), name='password-reset-confirm'),
    # path("password-reset/complete/", ResetPasswordCompleteView.as_view(), name='password-reset-complete'),
])

#+ static(settings.STATIC_URL, document_root=settings.STATIC_ROOT))

