#!/bin/bash

echo 1

sleep 1

mysql -e "create database wordpress;" 
mysql -e "grant all privileges on wordpress.* to wordpress@localhost;" 
mysql -e "flush privileges;"

sed -e 's/database_name_here/wordpress/' \
    -e 's/username_here/wordpress/' \
    -e 's/password_here//' \
    -e "/'AUTH_KEY'/ s/put your unique phrase here/$(pwgen -s -1 42)/" \
    -e "/'SECURE_AUTH_KEY'/ s/put your unique phrase here/$(pwgen -s -1 42)/" \
    -e "/'LOGGED_IN_KEY'/ s/put your unique phrase here/$(pwgen -s -1 42)/" \
    -e "/'NONCE_KEY'/ s/put your unique phrase here/$(pwgen -s -1 42)/" \
    -e "/'AUTH_SALT'/ s/put your unique phrase here/$(pwgen -s -1 42)/" \
    -e "/'SECURE_AUTH_SALT'/ s/put your unique phrase here/$(pwgen -s -1 42)/" \
    -e "/'LOGGED_IN_SALT'/ s/put your unique phrase here/$(pwgen -s -1 42)/" \
    -e "/'NONCE_SALT'/ s/put your unique phrase here/$(pwgen -s -1 42)/" \
    -i /etc/wordpress/wp-config.php

cat >> /etc/wordpress/wp-config.php <<EOF

/** Force SSL **/ 
define('FORCE_SSL', true);
define('FORCE_SSL_ADMIN',true);
EOF

sleep 1

yum -y install php-pecl-zendopcache

sed -e 's|^Alias /wordpress|#\0|' \
    -e '/Require ip 128.130.195.0/d' \
    -e '/Require local/a\    Require ip 128.130.195.0/25' \
    -i /etc/httpd/conf.d/wordpress.conf

sed -e 's/^SSLCertificateFile /#\0/' \
    -e 's/^SSLCertificateKeyFile/#\0/' \
    -i /etc/httpd/conf.d/ssl.conf

cat > /etc/httpd/conf.d/abenteuer.conf <<EOF
SSLCertificateFile /etc/pki/zkk/abenteuer.informatik.tuwien.ac.at-cert.pem
SSLCertificateKeyFile /etc/pki/zkk/abenteuer.informatik.tuwien.ac.at-key.pem
SSLCertificateChainFile /etc/pki/zkk/abenteuer.informatik.tuwien.ac.at-chain.pem

<Directory /usr/share/wordpress/wp-admin>
  AllowOverride Options
  <IfModule mod_authz_core.c>
    # Apache 2.4
    Require local
    Require ip 128.130.195.90
  </IfModule>
  <IfModule !mod_authz_core.c>
    # Apache 2.2
    Order Deny,Allow
    Deny from All
    Allow from 127.0.0.1
    Allow from ::1
 </IfModule>
</Directory>

<VirtualHost *:80>
  ServerName abenteuer.zkk.tuwien.ac.at
  DocumentRoot /var/www/html
</VirtualHost>

<VirtualHost *:80>
  ServerName abenteuer.informatik.tuwien.ac.at
  DocumentRoot /usr/share/wordpress

  RewriteEngine On
  RewriteCond %{HTTPS} Off [NC]
  RewriteCond %{HTTP_HOST} abenteuer.informatik.tuwien.ac.at [NC]
  RewriteRule (.*) https://abenteuer.informatik.tuwien.ac.at$1 [L,R=301]
</VirtualHost>

<VirtualHost *:443>
  ServerName abenteuer.informatik.tuwien.ac.at
  DocumentRoot /usr/share/wordpress

  SSLEngine on
  SSLProtocol             -All +TLSv1 +TLSv1.1 +TLSv1.2
  SSLCipherSuite          ECDH+AESGCM:DH+AESGCM:ECDH+AES256:DH+AES256:ECDH+AES128:DH+AES:ECDH+3DES:DH+3DES:RSA+AESGCM:RSA+AES:RSA+3DES:!aNULL:!MD5:!DSS
  SSLHonorCipherOrder     on
</VirtualHost>
EOF

touch /var/www/html/index.html

systemctl enable httpd.service
