cd /root/
interface=$(ip r | awk '/^default/ {print $5}' | head -1)
nameservers=$(cat /etc/resolv.conf | awk '/^nameserver/ {print $2}')
ipaddr=$(ifconfig $interface | grep "^[[:space:]]*inet [[:digit:]]" | awk '{print $2}')
netmask=$(ifconfig $interface | grep "^[[:space:]]*inet [[:digit:]]" | awk '{print $4}')
gateway=$(ip r | awk '/^default/ {print $3}' | head -1)
hostname=$(host ${ipaddr} |awk '{print $5}'|sed 's/.$//')
echo $interface $ipaddr $netmask $gateway $hostname $nameservers
sleep 5
cat /etc/sysconfig/network-scripts/ifcfg-${interface} | sed 's/"//g' | sed 's/NM_CONTROLLED=.*$//' | sed 's/BOOTPROTO=.*$//' | grep -v ^$ > ifcfg-${interface}
echo "IPADDR=${ipaddr}" >> ifcfg-${interface}
echo "NETMASK=${netmask}" >> ifcfg-${interface}
echo "GATEWAY=${gateway}" >> ifcfg-${interface}
echo "BOOTPROTO=none" >> ifcfg-${interface}
echo "NM_CONTROLLED=no" >> ifcfg-${interface}
echo "USERCTL=no" >> ifcfg-${interface}
i=0
for nameserver in $nameservers ; do
  i=$(($i+1))
  echo "DNS${i}=${nameserver}" >> ifcfg-${interface}
done
cat ifcfg-${interface}
mv ifcfg-${interface} /etc/sysconfig/network-scripts/
hostnamectl set-hostname ${hostname}
hostnamectl
