#/bin/bash

my_file=/etc/postfix/main.cf
cp ${my_file} ${my_file}.orig

sed -i "/^#myhostname = virtual/ amyhostname = $(hostname).zkk.tuwien.ac.at" ${my_file}
sed -i "/^#mydomain = domain/ amydomain = \$myhostname" ${my_file}
sed -i "s/^#\(myorigin = .mydomain\)/\1/" ${my_file}
sed -i "s/^inet_interfaces/#inet_interfaces/" ${my_file}
sed -i "s/^#inet_interfaces = all/inet_interfaces = all/" ${my_file}
sed -i "s/^#mynetworks_style = host/mynetworks_style = host/" ${my_file}
sed -i "/^#mynetworks = hash/ amynetworks = 127.0.0.1 128.130.195.0/25" ${my_file}
sed -i "s/^#recipient_delimiter = +/recipient_delimiter = +/" ${my_file}
sed -i "/^#mailbox_command = \/some\/where\/procmail -a / amailbox_command = /usr/libexec/dovecot/deliver" ${my_file}

yum -y install dovecot

my_file=/etc/dovecot/conf.d/10-mail.conf
cp ${my_file} ${my_file}.orig

cat > /etc/dovecot/conf.d/10-mail.conf << EOF
##
## Mailbox locations and namespaces
##
mail_location = maildir:/data/Mail/%n/Maildir
namespace inbox {
  type = private
  separator = /
  #prefix = INBOX/
  #location =
  inbox = yes
  #hidden = no
  #list = yes
  subscriptions = yes
}
mail_plugin_dir = /usr/lib64/dovecot
mail_plugins = notify mail_log fts fts_lucene
mbox_write_locks = fcntl
plugin {
  fts=lucene
  fts_lucene = whitespace_chars=@.
  fts_autoindex = yes
}
EOF

my_file=/etc/dovecot/conf.d/10-ssl.conf
cp ${my_file} ${my_file}.orig
sed -i "s%^ssl_cert = .*%ssl_cert = </etc/pki/zkk/wildcard.zkk.tuwien.ac.at.pem%" ${my_file}
sed -i "s%^ssl_key = .*%ssl_key = </etc/pki/zkk/wildcard.zkk.tuwien.ac.at.pem%" ${my_file}

my_file=/etc/dovecot/dovecot.conf
cp ${my_file} ${my_file}.orig
sed -i "/^#protocols = / aprotocols = imap" ${my_file}

systemctl enable dovecot.service

useradd -u 1000 -c "Local User"  -s /sbin/nologin -m local.user
useradd -u 1001 -c gitlab        -s /sbin/nologin -m -p '$6$uZ01ReX7qsKtJJXn$F0/aXizlcz9K1bB7cIz6FJFXmIBpe7lcw6aTzVXryOtrYm.Yi4NSDNMvNTiPuF.76vs.gPHFIVokpTkm7L9F60' gitlab
useradd -u 1002 -c mattermost    -s /sbin/nologin -m -p '$6$RDegjpKguEZSifhb$TQZG9pE7sB9DhngerEKLNz0TkfIicfmlfFRuFxnzGMSZIRy1gym8yw59aR33NzVOUQvRJqk.SM.CRnA0FhpLN1' mattermost
useradd -u 1003 -c stggitlab     -s /sbin/nologin -m -p '$6$bsiENIMHOAUAXZNF$CCzRnT1eBQpt7xIkx6ahvOZGyDSLPjDIA2PQsL55TMmAl5pUjKQjmMULiIYB8s/kvVhOtfjskKK8kbL25qg1X0' stggitlab
useradd -u 1004 -c stgmattermost -s /sbin/nologin -m -p '$6$0dDJPHoHBYTaIYC6$6RKTnLN5UKwm8ZJo.E/E.YDJkoSziuxhYsu5N5hpDgAcnMPw8aw3iOCWYfWLzz8wnsah19y7/we/no48z6Gp10' stgmattermost
useradd -u 1005 -c tbdgitlab     -s /sbin/nologin -m -p '$6$4NOQPRIdzKioVGWj$KvSofBEW8UttOBmdvhrIorb9LHPmA3SidrCJm.oDKb8k9.cCTRSuQJSIc/mUp4Kl6H1n.ZgS477qV8FqNdoAo/' tbdgitlab
useradd -u 1006 -c tbdmattermost -s /sbin/nologin -m -p '$6$YaDYYauAILHgFGr0$vONjeuWnYSlkh.pL97.Nf77Q1KrCN0WmNimGCJAt9fc9yDCv.pCZsrU.xCs/5bV3g25qZ6gIjLVp1IjaOdNBn1' tbdmattermost
