#!/bin/bash

my_name=inn.tuwien.ac.at

yum -y install mod_ssl mailman

## /etc/mailman/mm_cfg.py
#DEFAULT_CHARSET = 'utf-8'
#VERBATIM_ENCODING = ['utf-8']

my_file=/etc/mailman/mm_cfg.py
cp ${my_file} ${my_file}.orig
sed -i "s/^DEFAULT_URL_HOST   =.*$/DEFAULT_URL_HOST   = '${my_name}'/" ${my_file}
sed -i "s/^DEFAULT_EMAIL_HOST =.*$/DEFAULT_EMAIL_HOST = '${my_name}'/" ${my_file}
sed -i "s/^add_virtualhost.*$/\0\n\nMTA = 'Postfix'/" ${my_file}

## /etc/postfix/main.cf
my_file=/etc/postfix/main.cf
my_ip=$(host ${my_name} | sed "s/^.*address //")
cp ${my_file} ${my_file}.orig
sed -i "/^myhostname = / d"  ${my_file}
sed -i "/^#myhostname = virtual/ amyhostname = ${my_name}" ${my_file}
sed -i "/^mydomain = / d"  ${my_file}
sed -i "/^#mydomain =/ amydomain = ${my_name}" ${my_file}
sed -i "s/^inet_interfaces =.*$/inet_interfaces = ${my_ip}, localhost/" ${my_file}
sed -i "s%^alias_maps =.*$%alias_maps = hash:/etc/aliases, hash:/etc/mailman/aliases%" ${my_file}
sed -i "/^relayhost = / d" ${my_file}
sed -i "/^#relayhost = \$mydomain/ arelayhost = mail.zkk.tuwien.ac.at" ${my_file}

## /etc/httpd/conf.d/mailman.conf
my_file=/etc/httpd/conf.d/mailman.conf
cp ${my_file} ${my_file}.orig
sed -i "/^RedirectMatch  / d" ${my_file}
sed -i "/^# RedirectMatch /   aRedirectMatch ^/socialevents_doctoralstudents[/]*$ https://${my_name}/mailman/listinfo/socialevents_doctoralstudents"  ${my_file}
sed -i "/^# RedirectMatch / aRedirectMatch ^/mailman[/]*$ http://${my_name}/mailman/listinfo" ${my_file}
sed -i "/^# RedirectMatch / aRedirectMatch ^/$ http://${my_name}/mailman/listinfo" ${my_file}

/usr/lib/mailman/bin/mmsitepass assisprosek
#/usr/lib/mailman/bin/newlist -q admin listadmin@zkk.tuwien.ac.at assisprosek
#/usr/lib/mailman/bin/newlist -q news admin@inn.tuwien.ac.at assisprosek
#/usr/lib/mailman/bin/newlist -q socialevents_doctoralstudents clarissa.schmid@tuwien.ac.at assisprosek

systemctl disable mailman.service
systemctl disable httpd.service

