#!/bin/bash
dnf config-manager --set-enabled powertools
dnf install -y google-authenticator
# create
echo "create 2fa ..."
sudo -H -u "$UNAME" bash -c "google-authenticator --time-based --disallow-reuse --window-size=5 --rate-limit=1 --rate-time=15 --force --qr-mode=none --emergency-codes=0 --quiet"
# enforce
echo "adding pam_google_authenticator..."
echo "auth       required     pam_google_authenticator.so nullok" >> /etc/pam.d/sshd
# 2FA
echo "adding challenge ..."
sed -i "s/^ChallengeResponseAuthentication.*/ChallengeResponseAuthentication yes/g" /etc/ssh/sshd_config
sed -i "s/^UsePAM.*/UsePAM yes/g" /etc/ssh/sshd_config
# MFA
echo "adding mfa ..."
cat <<EOF >> /etc/ssh/sshd_config
Match Group mfa
	X11Forwarding no
	AllowTcpForwarding yes
	PermitTTY no
	AuthenticationMethods publickey,password publickey,keyboard-interactive
EOF