import {Injectable, OnInit} from '@angular/core';
import {BehaviorSubject, Observable} from "rxjs";
import {AuthService} from "../auth/auth.service";

@Injectable({
  providedIn: 'root'
})
export class CommonService {

  private action: BehaviorSubject<any> = new BehaviorSubject<any>(null)
  public action$: Observable<any> = this.action.asObservable()

  private heading: BehaviorSubject<any> = new BehaviorSubject<any>(null)
  public heading$: Observable<any> = this.heading.asObservable()

  private subheading: BehaviorSubject<any> = new BehaviorSubject<any>(null)
  public subheading$: Observable<any> = this.subheading.asObservable()

  private authenticated: BehaviorSubject<any> = new BehaviorSubject<any>(null)
  public authenticated$: Observable<any> = this.authenticated.asObservable()

  constructor(private auth: AuthService) {
  }

  public loadAuth(): Promise<{ success: boolean }> {
    return this.auth.isAuthenticated()
  }

  public setHeading(heading: string): void {
    this.heading.next(heading)
  }

  public setSubHeading(subheading: string): void {
    this.subheading.next(subheading)
  }

  public setAction(name: string, url: string): void {
    this.action.next({name, url})
  }

  public clearAction(): void {
    this.action.next(null)
  }

}
