import {Component, OnInit} from '@angular/core';
import {CommonService} from "../../services/common.service";

@Component({
  selector: 'app-vms',
  templateUrl: './vms.component.html',
  styleUrls: ['./vms.component.scss']
})
export class VmsComponent implements OnInit {

  heading = "Virtual Machines"
  vmsActive: any[] = []
  vmsInactive: any[] = []
  name: string = "Create Proposal"
  url: string = "virtual-machines/apply"

  constructor(private common: CommonService) {
  }

  ngOnInit(): void {
    this.common.setHeading(this.heading)
    this.common.setAction(this.name, this.url)
    this.loadVirtualMachines()
  }

  private loadVirtualMachines() {
    let vms = [{
      'name': 'Hello VM',
      'updated': new Date(),
      'type': 'analyst',
      'active': true
    },{
      'name': 'Olá VM',
      'updated': new Date(),
      'type': 'owner',
      'active': false
    }]
    vms.forEach(vm => {
      if (vm.active) {
        this.vmsActive.push(vm)
        return
      }
      this.vmsInactive.push(vm)
    })
    this.common.setSubHeading("All active and inactive VMs")
  }

}
