import {Component, OnInit} from '@angular/core';
import {CommonService} from "../../../services/common.service";
import {FormBuilder, FormGroup, Validators} from "@angular/forms";

@Component({
  selector: 'app-apply-vm',
  templateUrl: './apply-vm.component.html',
  styleUrls: ['./apply-vm.component.scss']
})
export class ApplyVmComponent implements OnInit {

  heading = "Data Analysis Proposal"
  subheading = "Disclose your research questions"

  dataGroup: any = null
  proposalGroup: any = null
  softwareGroup: any = null

  constructor(private common: CommonService,
              private formBuilder: FormBuilder) {
  }

  ngOnInit(): void {
    this.common.setHeading(this.heading)
    this.common.setSubHeading(this.subheading)
    this.dataGroup = this.formBuilder.group({
      firstCtrl: ['', Validators.required]
    });
    this.proposalGroup = this.formBuilder.group({
      secondCtrl: ['', Validators.required]
    });
    this.softwareGroup = this.formBuilder.group({
      secondCtrl: ['', Validators.required]
    });
  }

}
