import {Component, OnInit} from '@angular/core';
import {CommonService} from "../../../services/common.service";
import {FormControl, FormGroup, Validators} from "@angular/forms";

@Component({
  selector: 'app-signup',
  templateUrl: './signup.component.html',
  styleUrls: ['./signup.component.scss']
})
export class SignupComponent implements OnInit {

  heading = "Request Account"
  subheading = "Approval takes about one workday"

  signup: { fullname: string, username: string, organization: string, email: string, phone: string }
    = {fullname: '', username: '', organization: '', email: '', phone: ''}
  usernameValid: any = null

  public signupForm: FormGroup = new FormGroup({
    fullname: new FormControl(this.signup.fullname, [
      Validators.required
    ]),
    username: new FormControl(this.signup.username, [
      Validators.required,
      Validators.minLength(3)
    ]),
    organization: new FormControl(this.signup.organization, [
      Validators.required,
      Validators.minLength(4)
    ]),
    email: new FormControl(this.signup.email, [
      Validators.required,
      Validators.email
    ]),
    phone: new FormControl(this.signup.phone, [
      Validators.required,
      Validators.minLength(8)
    ]),
  });

  constructor(private common: CommonService) {
  }

  ngOnInit(): void {
    this.common.setHeading(this.heading)
    this.common.setSubHeading(this.subheading)
  }

  public submitForm(): void {
    console.debug('submit form', this.signup)
  }

  public suggestUsername(): void {
    this.signup.username = this.signup.fullname.toLowerCase()
  }

  public usernameValidIcon(): string {
    if (this.usernameValid === true) {
      return 'done'
    }
    if (this.usernameValid === false) {
      return 'do_disturb_alt'
    }
    return ''
  }

}
