import {Component, OnDestroy, OnInit} from '@angular/core';
import {CommonService} from '../../services/common.service';
import {Subscription} from 'rxjs';

@Component({
  selector: 'app-toolbar',
  templateUrl: './toolbar.component.html',
  styleUrls: ['./toolbar.component.scss']
})
export class ToolbarComponent implements OnInit, OnDestroy {

  private authenticatedSubscription: Subscription = new Subscription()

  private actionSubscription: Subscription = new Subscription()
  private headingSubscription: Subscription = new Subscription()
  private subHeadingSubscription: Subscription = new Subscription()

  public action: any
  public heading: any
  public subheading: any
  public authenticated: any

  constructor(private common: CommonService) {
  }

  ngOnInit(): void {
    this.loadAuth()
    this.actionSubscription = this.common.action$.subscribe(action => this.action = action);
    this.headingSubscription = this.common.heading$.subscribe(heading => this.heading = heading);
    this.subHeadingSubscription = this.common.subheading$.subscribe(subheading => this.subheading = subheading);
  }

  ngOnDestroy(): void {
    this.actionSubscription.unsubscribe()
    this.headingSubscription.unsubscribe()
    this.subHeadingSubscription.unsubscribe()
  }

  private loadAuth(): void {
    this.common.loadAuth()
      .then(response => {
        if (response.success) {
          this.authenticated = true;
          console.debug('authenticated the user')
          return
        }
        this.authenticated = false
        console.error('failed to authenticate the user')
      })
      .catch(error => {
        this.authenticated = false
        console.error('failed to authenticate the user', error)
      })
  }

}
