import {NgModule} from '@angular/core';
import {BrowserModule} from '@angular/platform-browser';

import {AppRoutingModule} from './app-routing.module';
import {AppComponent} from './app.component';
import {BrowserAnimationsModule} from '@angular/platform-browser/animations';
import {ToolbarComponent} from './components/toolbar/toolbar.component';
import {MatToolbarModule} from '@angular/material/toolbar';
import {MatButtonModule} from '@angular/material/button';
import {MatIconModule} from '@angular/material/icon';
import {OneTimePasswordComponent} from './components/one-time-password/one-time-password.component';
import {MatCardModule} from '@angular/material/card';
import {MatDividerModule} from '@angular/material/divider';
import {MatFormFieldModule} from '@angular/material/form-field';
import {MatInputModule} from '@angular/material/input';
import {FormsModule, ReactiveFormsModule} from '@angular/forms';
import {ClipboardModule} from '@angular/cdk/clipboard';
import {MatSnackBarModule} from '@angular/material/snack-bar';
import {ApplyVmComponent} from './components/virtual-machines/apply/apply-vm.component';
import {WelcomeComponent} from './components/welcome/welcome.component';
import {MatSelectModule} from '@angular/material/select';
import {MatListModule} from '@angular/material/list';
import {MatBadgeModule} from '@angular/material/badge';
import {VmsComponent} from './components/virtual-machines/vms.component';
import {MatMenuModule} from '@angular/material/menu';
import {MatStepperModule} from '@angular/material/stepper';
import {AuthGuard} from './auth/auth.guard';
import {HttpClientModule} from '@angular/common/http';
import {LoginComponent} from "./components/user/login/login.component";
import {SignupComponent} from "./components/user/signup/signup.component";

@NgModule({
  declarations: [
    AppComponent,
    ToolbarComponent,
    OneTimePasswordComponent,
    ApplyVmComponent,
    WelcomeComponent,
    VmsComponent,
    LoginComponent,
    SignupComponent,
  ],
  imports: [
    BrowserModule,
    AppRoutingModule,
    BrowserAnimationsModule,
    MatToolbarModule,
    MatButtonModule,
    MatIconModule,
    MatCardModule,
    MatDividerModule,
    MatFormFieldModule,
    MatInputModule,
    FormsModule,
    ClipboardModule,
    MatSnackBarModule,
    ReactiveFormsModule,
    MatSelectModule,
    MatListModule,
    MatBadgeModule,
    MatMenuModule,
    MatStepperModule,
    HttpClientModule
  ],
  providers: [AuthGuard],
  bootstrap: [AppComponent]
})
export class AppModule {
}
