import {NgModule} from '@angular/core';
import {RouterModule, Routes} from '@angular/router';
import {ApplyVmComponent} from './components/virtual-machines/apply/apply-vm.component';
import {OneTimePasswordComponent} from './components/one-time-password/one-time-password.component';
import {WelcomeComponent} from './components/welcome/welcome.component';
import {VmsComponent} from './components/virtual-machines/vms.component';
import {AuthGuard} from './auth/auth.guard';
import {LoginComponent} from './components/user/login/login.component';
import {SignupComponent} from './components/user/signup/signup.component';

const routes: Routes = [
  {path: '', component: WelcomeComponent},
  {path: 'user/login', component: LoginComponent},
  {path: 'user/signup', component: SignupComponent},
  {path: 'one-time-passwords', component: OneTimePasswordComponent, canActivate: [AuthGuard]},
  {path: 'virtual-machines', component: VmsComponent, canActivate: [AuthGuard]},
  {path: 'virtual-machines/apply', component: ApplyVmComponent, canActivate: [AuthGuard]},
];

@NgModule({
  imports: [RouterModule.forRoot(routes)],
  exports: [RouterModule]
})
export class AppRoutingModule {
}
