cd /root/
## get primary interface
connection=$(nmcli -t connection show |head -1 |awk -F: '{print $1}')
device=$(nmcli -t connection show |grep "^${connection}" |awk -F: '{print $4}')
ipaddr=$(nmcli -t device show ${device} |grep "^IP4.ADDRESS\[" |sed "s/^.*://" |paste -sd ",")
gateway=$(nmcli -t device show ${device} |grep "^IP4.GATEWAY:" |sed "s/^.*://")
dns=$(nmcli -t device show ${device} |grep "^IP4.DNS\[" |sed "s/^.*://" |paste -sd ",")
hostname=$(host ${ipaddr%/[0-9]*} |awk '{print $5}'|sed 's/.$//')
echo Network parameters
echo nmcli connection modify \"${connection}\" ipv4.addresses "${ipaddr}" ipv4.gateway "${gateway}" ipv4.dns "${dns}" ipv4.method "manual" 
nmcli connection modify "${connection}" ipv4.addresses "${ipaddr}" ipv4.gateway "${gateway}" ipv4.dns "${dns}" ipv4.method "manual"

nmcli connection show "${connection}" |grep ^ipv4

hostnamectl set-hostname ${hostname}
hostnamectl

dnf -y install iptables-services

if [ -e /mnt/tmp/etc/sysconfig/iptables_$(hostname -f) ] ; then
  cp /mnt/tmp/etc/sysconfig/iptables_$(hostname -f) /etc/sysconfig/iptables
else 
  cp /mnt/tmp/etc/sysconfig/iptables /etc/sysconfig/iptables
fi

systemctl disable firewalld
systemctl enable iptables.service
systemctl enable NetworkManager.service
