/root/
dnf -y install dnsmasq

cat > /etc/dnsmasq.d/base.conf <<EOF
# restrict to interfaces
interface=enp3s0
#interface=lo
bind-interfaces
#log-queries
log-dhcp
log-facility=/var/log/dnsmasq.log
EOF

cat > /etc/dnsmasq.d/dhcp.conf <<EOF
dhcp-authoritative
dhcp-no-override
dhcp-boot=pxelinux.0

##192.168.126.240/28
dhcp-range=tag:WBS,192.168.126.240,static,255.255.255.240,1h
#dhcp-range=tag:WBS,192.168.126.250,192.168.126.252,1h
dhcp-option=tag:WBS,option:netmask,255.255.255.240
dhcp-option=tag:WBS,option:router,192.168.126.241
dhcp-option=tag:WBS,option:dns-server,128.130.195.37
dhcp-option=tag:WBS,option:domain-search,zkk.tuwien.ac.at
dhcp-option=tag:WBS,option:ntp-server,128.130.2.3,128.130.3.131,128.131.2.3

##192.168.126.224/28
dhcp-range=tag:WBP,192.168.126.224,static,255.255.255.240,1h
#dhcp-range=tag:WBP,192.168.126.250,192.168.126.252,1h
dhcp-option=tag:WBP,option:netmask,255.255.255.240
dhcp-option=tag:WBP,option:router,192.168.126.225
dhcp-option=tag:WBP,option:dns-server,128.130.195.37
dhcp-option=tag:WBP,option:domain-search,zkk.tuwien.ac.at
dhcp-option=tag:WBP,option:ntp-server,128.130.2.3,128.130.3.131,128.131.2.3

##128.130.195.0/25
dhcp-range=tag:ZKK,128.130.195.104,128.130.195.111,255.255.255.128,2h
dhcp-option=tag:ZKK,option:netmask,255.255.255.128
dhcp-option=tag:ZKK,option:router,128.130.195.1
#dhcp-option=tag:ZKK,option:dns-server,128.130.195.37,128.130.4.3,128.131.4.3
dhcp-option=tag:ZKK,option:dns-server,128.130.195.37
#dhcp-option=tag:ZKK,option:dns-server,128.130.4.3
dhcp-option=tag:ZKK,option:domain-search,zkk.tuwien.ac.at
dhcp-option=tag:ZKK,option:ntp-server,128.130.2.3,128.130.3.131,128.131.2.3
EOF

cat > /etc/dnsmasq.d/dns.conf <<EOF
domain-needed
filterwin2k
no-negcache
domain=zkk.tuwien.ac.at
expand-hosts
resolv-file=/etc/resolv-tu.conf

addn-hosts=/etc/hosts.mgmt
addn-hosts=/etc/hosts.zkk
addn-hosts=/etc/hosts.iscsi
addn-hosts=/etc/hosts.bui
addn-hosts=/etc/hosts.w18
EOF

cat > /etc/dnsmasq.d/tftp.conf <<EOF
# enable-tftp
# tftp-root=/tftpboot/pxe
EOF

cat > /etc/resolv.conf <<EOF
domain zkk.tuwien.ac.at
search zkk.tuwien.ac.at zkk.tuwien.ac.at.
nameserver 127.0.0.1
nameserver 128.130.195.37
nameserver 128.130.4.3
nameserver 128.131.4.3
EOF

cat > /etc/resolv-tu.conf <<EOF
domain zkk.tuwien.ac.at
search zkk.tuwien.ac.at zkk.tuwien.ac.at.
nameserver 128.130.4.3
nameserver 128.131.4.3
EOF

cat > /root/bin/copy-hosts-files-from-installer.sh <<EOF
#!/bin/bash

x_files=\$(cat /etc/dnsmasq.d/dns.conf | awk -F= '/^addn-hosts=/ {print \$2}'; echo ' /etc/ethers.zkk')
for x_file in \$x_files ; do
  scp installer:\$x_file /etc/
done
EOF
chmod +x /root/bin/copy-hosts-files-from-installer.sh

cat > /root/bin/update_dnsmasq_ethers.sh <<EOF
#!/bin/bash
cat /etc/ethers.zkk | sed s/#.*\$// | grep -v "^[[:space:]]*\$" | sed s/^/dhcp-host=/ | sed "s/ /,set:ZKK,/" > /tmp/dhcp-hosts.conf
sed -i "s/:ZKK,stgw18/:WBS,stgw18/; s/:ZKK,WBS/:WBS,WBS/; s/:ZKK,prdw18/:WBP,prdw18/; s/:ZKK,WBP/:WBP,WBP/; s/:ZKK,MGT/:MGT,MGT/; s/:ZKK,ILO/:MGT,ILO/;" /tmp/dhcp-hosts.conf
mv /tmp/dhcp-hosts.conf /etc/dnsmasq.d/dhcp-hosts.conf
/etc/init.d/dnsmasq restart
# cp -u /etc/ethers.zkk /opt/repos/ZKK/
# cp -u /etc/hosts.zkk /opt/repos/ZKK/
EOF
chmod +x /root/bin/update_dnsmasq_ethers.sh

