-- ENUM

CREATE TYPE datatype AS ENUM ('other', 'csv');

-- SEQUENCES

CREATE SEQUENCE IF NOT EXISTS sq_requested;

CREATE SEQUENCE IF NOT EXISTS sq_granted;

-- TABLES

CREATE TABLE IF NOT EXISTS requests
(
    id integer primary key default nextval('sq_requested'),
    type datatype default 'other',
    path text unique,
    created_at timestamp without time zone default now()
);

CREATE TABLE IF NOT EXISTS grants
(
    id integer primary key default nextval('sq_granted'),
    request_id integer references requests(id),
    granted boolean default 'false',
    created_at timestamp without time zone default now()
);
