# Open Source Secure Data Infrastructure and Processes

Already very early on during the rise of the COVID-19 pandemic, the need for solid, data-driven decision was recognized.

## Description

During meetings of the COVID-19 Future Operations Clearing Board, a national expert platform it became evident that access to essential data was missing. This was primarily due to the impossibility of [Data Owner](https://gitlab.tuwien.ac.at/martin.weise/ossdip/-/wikis/roles/Data-Owner) to share their data with experts, either due to privacy reasons (medical, social science), but also due to the massive risk involved in sharing commercially sensitive data. In order to break this deadlock, TU Wien within a timeframe of two weeks set up a high-security data infrastructure and according processes to allow data owners to provide:

1. Highly selective access (data visiting),
2. To specific (fine-granular or aggregated, fingerprinted) subsets of data,
3. For identified individuals,
4. For limited periods of time, and
5. To answer precisely defined questions accepted by the [Data Owner](https://gitlab.tuwien.ac.at/martin.weise/ossdip/-/wikis/roles/Data-Owner)

## Expertise

This infrastructure - and specifically its fast set-up and deployment to support the work of the COVID-19 Future Operations Board was possible as we could build on experience gained by operating a very similar infrastructure in the health care sectore for many years as part of the [DEXHELPP](http://www.dexhelpp.at/) project.

## Project Goal

The goal of this project, is to clean up, document and enhance this infrastructure to provide a fully documented, entirely open-source based reference implementation of a secure data infrastructure (OSSDIP) supporting data visiting. This will allow institutions to quickly set-up and deploy a similar solution to provide access to their data. It addresses the RDA COVID-19 Recommendations, that: 

>Measures should be taken in order to organise the sharing of data and trial documents in a suitable, trustworthy and secure data repository, and provides some core functionality of the Safe Setting component of Trusted Research Environments as set out in the Green Paper of the UK Health Research Data Alliance. 

It allows data not sharable via existing COVID-19 data portals to be used for analysis by enabling data owners to make their data visitable and usable in a fully controlled manner. It is thus meant to complement existing Open Data portals and support access to sensitive and not openly sharable data.

## Acknowledgement

This project is supported by EOSC Secretariat in cooperation with COVID-19 Future Operations.

## Contributing

Please contact [Ao.Univ.Prof. Andreas Rauber](https://tiss.tuwien.ac.at/person/39608.html) via email.

> Vienna University of Technology<br />
> Institute of Information Systems Engineering<br/>
> Information and Software Engineering Group
